#include <allegro.h>
#include "main.h"
#include "game.h"
#include "map.h"
#include "army.h"
#include "castle.h"

MAP *map;

MAP *map_create(int type)
{
	MAP *map = (MAP *)malloc(sizeof(MAP));
	int x, y;

	map->color[TILE_GRASS] = 1;
	map->color[TILE_ROCKS] = 2;
	map->color[TILE_TREES] = 3;

	map->castles = NULL;
	map->armies = NULL;

	if (!type)
		return map;


	for (y=0; y<19; y++)
		for (x=0; x<19; x++)
		{			
			map->grid[y][x].tile = TILE_GRASS;
			map->grid[y][x].castle = NULL;
			map->grid[y][x].x = x;
			map->grid[y][x].y = y;
		}

	if (type != TYPE_PLAINS)
	{
		/* place the mountains */
		int last_x = 11 - (rand() % 4);
		int i;

		for (y=0; y<19; y++)
		{
			do {
				x = last_x + ((rand()%3) - 1);
			} while (x < 5 || x > 13);

			map->grid[y][x].tile = TILE_ROCKS;
			if ((rand()%100) < 90) map->grid[y][x+1].tile = TILE_ROCKS;
			last_x = x;
		}

		/* create up to three openings */
		for (i=0; i<3; i++)
		{
			y = rand() % 19;
			for (x=0; x<19; x++) map->grid[y][x].tile = TILE_GRASS;
		}

		/* place the trees */
		if (type == TYPE_FOREST)
			i = (rand() % 25) + 25;
		else
			i = (rand() % 50) + 50;

		while (i--)
		{
			y = rand() % 19;
			x = rand() % 19;
			if (map->grid[y][x].tile == TILE_GRASS)
				map->grid[y][x].tile = TILE_TREES;

			if (type == TYPE_FOREST)
			{
				if (y < 18 && map->grid[y+1][x].tile == TILE_GRASS) map->grid[y+1][x].tile = TILE_TREES;
				if (x < 18 && map->grid[y][x+1].tile == TILE_GRASS) map->grid[y][x+1].tile = TILE_TREES;
				if (y > 0 && map->grid[y-1][x].tile == TILE_GRASS) map->grid[y-1][x].tile = TILE_TREES;
				if (x > 0 && map->grid[y][x-1].tile == TILE_GRASS) map->grid[y][x-1].tile = TILE_TREES;

			}
		}
	}

	return map;
}

void map_destroy(MAP *map)
{
	army_destroy(&map->armies);
	castle_destroy(&map->castles);
	free(map);
}

void map_add_castles(MAP *map, int lord_count, int castle_count)
{
	while (castle_count--)
	{
		int x,y;
		CASTLE *castle = castle_add(&map->castles);

		do
		{
			x = rand() % (lord_count ? 7 : 19);
			y = rand() % (lord_count ? 7 : 19);

			if (lord_count == 4 || lord_count == 2) x += 12;
			if (lord_count == 3 || lord_count == 2) y += 12;			
			
		} while (map->grid[y][x].tile != TILE_GRASS && map->grid[y][x].tile != TILE_TREES);

		map->grid[y][x].tile = TILE_CASTLE;
		castle->x = x;
		castle->y = y;
		castle->player = lord_count;

		if (lord_count)
		{
			lord_count--;
			castle->levy = (rand() % 3) + 9;			
			castle->soldiers = castle->levy * 6 + 20;			
		}
		else
		{
			castle->levy = (rand() % 10) + 1;
			castle->soldiers = castle->levy * 2 + 10;			
		}

		

		map->grid[y][x].castle = castle;
	}
}

void map_draw(MAP *map, BITMAP *bmp, int xo, int yo)
{
	int x, y;
	CASTLE *castle = map->castles;
	ARMY *army = map->armies;

	for (y=0; y<19; y++)
		for (x=0; x<19; x++)
		{	
			textprintf_ex(bmp, font64, x*16 + xo, y*8 + yo, map->color[map->grid[y][x].tile], -1, "%c%c", map->grid[y][x].tile, map->grid[y][x].tile);
			//draw_sprite(bmp, map->tiles[map->grid[y][x].tile], x*16 + xo, y*8 + yo);
		}

	while (castle)
	{
		textprintf_ex(bmp, font64, castle->x*16 + xo, castle->y*8 + yo, 4+castle->player, -1, "%c%c", TILE_CASTLE,TILE_CASTLE+1);
		castle = castle->next;
	}

	while (army)
	{
		if (map->grid[army->y][army->x].tile == TILE_GRASS)
		{
			textprintf_ex(bmp, font64, army->x*16 + xo, army->y*8 + yo, 4+army->player, -1, "%c%c", TILE_ARMY,TILE_ARMY+1);
		}
		army = army->next;
	}
}

/* A short cut function that checks for castles or troops at a given location  */
int map_get_enemy(MAP *map, int x, int y, int player)
{
	return map->grid[y][x].castle && map->grid[y][x].castle->player != player ? map->grid[y][x].castle->player : army_get_enemy(map->armies, x, y, player);
}

/* A short cut function that returns the number of troops and castle soldiers at a given location */
int map_get_enemy_size(MAP *map, int x, int y, int player)
{
	return army_get_enemy_size(map->armies, x, y, player) + (map->grid[y][x].castle && map->grid[y][x].castle->player != player ? map->grid[y][x].castle->soldiers : 0);
}

/* Reduces the troops at the given location by the given size */
void map_reduce_troops(MAP *map, int x, int y, int lord, int reduce_size)
{
	ARMY *army = map->armies;

	/* kill idle troops first */
	while (army)
	{
		if (army->x == x && army->y == y && army->player == lord && army->idle == TRUE)
		{
			if (army->size > reduce_size)
			{
				/* army is bigger than new size */
				army->size -= reduce_size;
				return;
			}
			else
			{
				/* army is less than or equal to reduce size, every one is dead. :( */
				reduce_size -= army->size;
				if (game_mode == MODE_MASTER) game_send_army_dead(army);
				army = army_remove(&map->armies, army);				
				if (!reduce_size) return;
				continue;
			}
		}
		army = army->next;
	}

	army = map->armies;
	/* kill active troops next */
	while (army)
	{
		if (army->x == x && army->y == y && army->player == lord && army->idle == FALSE)
		{
			if (army->size > reduce_size)
			{
				/* army is bigger than new size */
				army->size -= reduce_size;
				return;
			}
			else
			{
				/* army is less than kill size, every one is dead. :( */
				reduce_size -= army->size;
				if (game_mode == MODE_MASTER) game_send_army_dead(army);
				army = army_remove(&map->armies, army);
				if (!reduce_size) return;
				continue;
			}
		}
		army = army->next;
	}

	/* kill castle guards. The castle *SHOULD* exist here, but check to make sure. */
	if (map->grid[y][x].castle && map->grid[y][x].castle->player == lord)
	{
		map->grid[y][x].castle->soldiers -= reduce_size;		
		if (map->grid[y][x].castle->soldiers < 0) map->grid[y][x].castle->soldiers = 0;
	}
}

int map_tile_cost(int x, int y, int player)
{
	return 0;
}

MAP_POINT_STACK olist, clist;
int goal_player, goal_x, goal_y;

INLINE void map_list_add_to_open(MAP_POINT *p)
{
	p->is_opened = TRUE;
	olist.point[olist.size++] = p;
}

INLINE void map_list_close(MAP_POINT *p)
{
	p->is_closed = TRUE;
	clist.point[clist.size++] = p;
}

INLINE MAP_POINT *map_list_get_lowest_f()
{
	int i, lowest_i=0;
	MAP_POINT *lowest = olist.point[0];
	for (i=1; i<olist.size; i++)
		if (olist.point[i]->f < lowest->f)
		{
			lowest = olist.point[i];
			lowest_i = i;
		}

	if (lowest)
	{		
		map_list_close(lowest);
		lowest->is_opened = FALSE;
		olist.point[lowest_i] = olist.point[--olist.size];
	}

	return lowest;
}

int map_list_check(MAP_POINT *point1, MAP_POINT *point2)
{
	if (point2->tile != TILE_ROCKS && point2->is_closed == FALSE)
	{
		int g;
		switch (point2->tile)
		{
			case TILE_GRASS:
				g = 5;
			break;

			case TILE_TREES:
				g = 2;
			break;

			case TILE_CASTLE:
				g = point2->castle->player == goal_player ? 1 : 50;
			break;
		}

		if (!point2->is_opened)
		{
			point2->g = g + point1->g;
			point2->h = ABS(point2->x - goal_x) * 5 + ABS(point2->y - goal_y) * 5;
			point2->f = point2->g + point2->h;
			point2->parent = point1;

			map_list_add_to_open(point2);
		}
		else
		{
			/* new path is closer */
			if (g + point1->g < point2->g)
			{
				point2->g = g + point1->g;
				point2->f = point2->g + point2->h;
				point2->parent = point1;
			}
		}

		if (point2->x == goal_x && point2->y == goal_y) return TRUE;
	}

	return FALSE;
}

/*
	Path Finding
*/
MAP_POINT *map_next_step(int player, MAP_POINT *source, MAP_POINT *dest)
{
	MAP_POINT *lowest = NULL;
	if (source != dest)
	{
		int x, y;

		for (y=0; y<19; y++)
			for (x=0; x<19; x++)
			{
				map->grid[y][x].is_opened = FALSE;
				map->grid[y][x].is_closed = FALSE;
			}
		olist.size = 0;
		clist.size = 0;
		
		goal_player = player;
		goal_x = dest->x;
		goal_y = dest->y;

		source->parent = NULL;
		source->f = 0;
		source->g = 0;		
		source->h = 0;
		map_list_add_to_open(source);
		
		while ( (lowest = map_list_get_lowest_f()) )
		{			
			if (lowest->y > 0 && map_list_check(lowest, &map->grid[lowest->y-1][lowest->x])) break;
			if (lowest->y < 18 && map_list_check(lowest, &map->grid[lowest->y+1][lowest->x])) break;
			if (lowest->x > 0 && map_list_check(lowest, &map->grid[lowest->y][lowest->x-1])) break;
			if (lowest->x < 18 && map_list_check(lowest, &map->grid[lowest->y][lowest->x+1])) break;			
		}

		if (!dest->is_opened)
			lowest = NULL;
		else
		{
			//BITMAP *buffer = gfx_frame_start(gfx);			
			//map_draw(map, buffer, 8,8);
			lowest = dest;
			while (lowest->parent != source)
			{
				lowest = lowest->parent;
				//rect(buffer, 8+lowest->x*16,8+lowest->y*8, 8+lowest->x*16+15,8+lowest->y*8+7, 15);
			}
			//gfx_frame_end(gfx);
			
			//readkey();
		}		
	}
	return lowest;
}
